	function [Ghp, Zhp, Php] = PZ_2_HP_Z(G, Z, P, OmegaT, wcT)
	
	% 	Transforms the poles and zeros of a digital lowpass filter with   
	% 	cutoff frequency, OmegaT, to a highpass filter the passband edge wcT
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Lars Wanhammar 2004-09-22
	% Modified by: 		 
	% Copyright:		by authors - not released for commercial use
	% Version: 			1
	% Known bugs: 
	% Report bugs to:	Wanhammar@gmail.com
	
	alpha = -cos((OmegaT+wcT)/2)/cos((OmegaT-wcT)/2);
	
	% Transform LP zeros to HP zeros	
	Zhp =  -(Z+alpha)./(1+alpha*Z);
	
	% Transform LP poles to HP poles
	Php =  -(P+alpha)./(1+alpha*P);
	
	% Transform any zeros at infinity for the LP filter
	for n = length(Z)+1:length(P)
		Zhp(n) = 0;
	end

	Ghp = G*real(prod(1+alpha*Z)/prod(1+alpha*P));
	
